unit mRucksack;

interface
uses mAusgabe, sysUtils;
 const max = 50;
 type TWare = class
    private
      zName:char;
      zWert, zGewicht :real;
    public
      constructor create(pName:char; pWert, pGewicht:real);
 end;
 type TRucksack = class
    private
      zWarenkorb : array [1..max] of TWare;
      zanzahl: integer;
      zSack : set of char;
      Gesamtgewicht,Gesamtwert: Real;
      zMaxWert:real;
      zLoesung:String;
      zmaxGewicht:real;
      zSchritte:integer;
      hAusgabe : TfrmAusgabe;
    public
      constructor create;
      procedure addWare(pName:char; pWert, pGewicht:real);
      procedure Loese(maxGewicht:real);
      function Loesung:String;
      procedure Loesungsschritt(anzahl:integer);
 end;
implementation
  constructor TWare.create(pName:char; pWert, pGewicht:real);
  begin
    zName := pName; zWert := pWert; zGewicht := pGewicht;
  end;

  constructor TRucksack.create;
  begin
    zSack := [];  zAnzahl := 0;
    zLoesung := '';
    hAusgabe := TfrmAusgabe.Create(nil);
    hAusgabe.Show;
  end;
  procedure TRucksack.addWare(pName:char; pWert, pGewicht:real);
  begin
    inc(zAnzahl);
    zWarenkorb[zAnzahl] := TWare.create(pName,pWert, pGewicht);
    hAusgabe.memAus.Lines.Add(inttostr(zAnzahl)+' '+pName+' ' +
    floattostr(pWert)+' ' +floattostr(pGewicht));
  end;
  function TRucksack.Loesung:String;
  begin Loesung := zLoesung; end;

  procedure TRucksack.Loese(maxGewicht:real);
  begin
    zmaxGewicht := maxGewicht;
    zMaxWert:=0;
    Gesamtgewicht:= 0; Gesamtwert := 0;
    zSchritte :=0;
    hAusgabe.memAus.Lines.Add(inttostr(zAnzahl)+' '+floattostr(maxGewicht));
    Loesungsschritt(1);
    hAusgabe.memAus.Lines.Add('Schritte : '+inttostr(zSchritte));
  end;
  procedure TRucksack.Loesungsschritt(anzahl:integer);
  var c : char;
  begin
    
    if anzahl <= zanzahl then begin   zSchritte := zSchritte+1;
      hAusgabe.memAus.Lines.Add(inttostr(anzahl));
      if Gesamtgewicht + zWarenkorb[anzahl].zGewicht <= zmaxGewicht then begin
         zSack := zSack + [zWarenkorb[anzahl].zName];
         Gesamtwert := Gesamtwert + zWarenkorb[anzahl].zWert;
         Gesamtgewicht := Gesamtgewicht+ zWarenkorb[anzahl].zGewicht;
         if Gesamtwert > zMaxWert then begin
           zMaxWert := Gesamtwert; zLoesung :='';
           for c := 'A' to 'z' do if c in zSack then zLoesung := zLoesung+c;
           zLoesung := zLoesung + ' : ' + floattostr(zMaxWert);
         end;
         Loesungsschritt(anzahl+1);
         Gesamtgewicht := Gesamtgewicht- zWarenkorb[anzahl].zGewicht;
         Gesamtwert := Gesamtwert - zWarenkorb[anzahl].zWert;
         zSack := zSack - [zWarenkorb[anzahl].zName];
      end ;
      Loesungsschritt(anzahl+1);
    end;
  end;
end.
 